// Initialize Swiper.js for the gallery
const swiper = new Swiper('.swiper-container', {
  slidesPerView: 1,
  spaceBetween: 10,
  navigation: {
    nextEl: '.swiper-button-next',
    prevEl: '.swiper-button-prev',
  },
  breakpoints: {
    768: {
      slidesPerView: 2,
      spaceBetween: 20,
    },
    1024: {
      slidesPerView: 3,
      spaceBetween: 30,
    },
  },
});

// Register ScrollTrigger with GSAP
gsap.registerPlugin(ScrollTrigger);

// GSAP Animations
gsap.from('.hero h1', { duration: 1.5, y: -50, opacity: 0, ease: 'power3.out' });
gsap.from('.hero p', { duration: 1.5, y: 50, opacity: 0, delay: 0.5, ease: 'power3.out' });
gsap.from('.btn-custom', { duration: 1, scale: 0.8, opacity: 0, delay: 1, ease: 'bounce' });

gsap.utils.toArray('#features .col-md-4').forEach((feature, i) => {
  gsap.from(feature, {
    scrollTrigger: {
      trigger: feature,
      start: 'top 90%',
    },
    opacity: 0,
    y: 50,
    duration: 0.7 + i * 0.1,
    ease: 'power2.out',
  });
});

gsap.from('#gallery h2', {
  scrollTrigger: {
    trigger: '#gallery',
    start: 'top 90%',
  },
  opacity: 0,
  y: -30,
  duration: 1,
});

gsap.from('#reviews h2', {
  scrollTrigger: {
    trigger: '#reviews',
    start: 'top 90%',
  },
  opacity: 0,
  x: -50,
  duration: 1,
});

// Initialize Swiper for Pricing Carousel
const pricingSwiper = new Swiper('.pricing-swiper', {
  slidesPerView: 3,
  spaceBetween: 30,
  centeredSlides: true,
  loop: true,
  autoplay: {
    delay: 3000,
    disableOnInteraction: false,
  },
  navigation: {
    nextEl: '.swiper-button-next',
    prevEl: '.swiper-button-prev',
  },
  breakpoints: {
    640: {
      slidesPerView: 1,
    },
    768: {
      slidesPerView: 2,
    },
    1024: {
      slidesPerView: 3,
    },
  },
});

// Detect scroll direction to hide/show navbar
let lastScrollTop = 0;
const navbar = document.getElementById('mainNavbar');

window.addEventListener('scroll', () => {
  const currentScrollTop = window.pageYOffset || document.documentElement.scrollTop;
  if (currentScrollTop > lastScrollTop) {
    navbar.classList.add('hidden');
  } else {
    navbar.classList.remove('hidden');
  }
  lastScrollTop = Math.max(0, currentScrollTop);
});

// Initialize EmailJS
emailjs.init({
  publicKey: "R0ePa6OQMQCqpZWnO",
});

// Subscription Form Handling
document.getElementById("subscriptionForm").addEventListener("submit", (e) => {
  e.preventDefault();

  // Obtener valores del formulario
  const name = document.getElementById("name").value.trim();
  const email = document.getElementById("email").value.trim();

  // Validar que no estén vacíos
  if (!name || !email) {
    alert("Por favor, completa todos los campos.");
    return;
  }

  // Parámetros dinámicos para la plantilla
  const templateParams = {
    to_name: name, // Nombre del usuario
    to_email: email, // Email ingresado por el usuario
    website_name: "Infinity Smartwatch", // Nombre del sitio web
  };

  // Enviar el correo
  emailjs
    .send("service_d1qegq9", "template_icfyvj8", templateParams)
    .then(() => {
      console.log("Correo enviado con éxito");

      // Mostrar un modal de confirmación (si existe en el HTML)
      const modal = new bootstrap.Modal(document.getElementById("subscriptionModal"));
      modal.show();

      // Reiniciar el formulario
      e.target.reset();
    })
    .catch((error) => {
      console.error("Error al enviar el correo:", error);
      alert("Hubo un problema al enviar tu suscripción. Por favor, inténtalo de nuevo.");
    });
});

// Handle buy button clicks
document.querySelectorAll('.buy-btn').forEach((button) => {
  button.addEventListener('click', (e) => {
    const model = e.target.getAttribute('data-model');
    console.log(`Modelo seleccionado: ${model}`);
    window.location.href = `buy.html?model=${model}`;
  });
});
